#!/usr/local/bin/perl

# generate argus config file '011_customer_conn' 
# by examining saved cisco configs

$dir="/export/home/config/cust/broadview/routers";
opendir DIR, "$dir" || die "couldnt open dir: $!\n";
        @subdirs=readdir(DIR);
closedir DIR;

foreach( @subdirs ){
        next if( /^\./ || $_ eq "Override" );
        $subdir=$_;
        opendir DIR, "$dir/$subdir" || die "cannot open dir: $dir/$_: $!\n";
                foreach( readdir(DIR) ){
                        $last=$_;
                }
                push @files, "$dir/$subdir/$last";
        closedir DIR;
}

open C, ">/export/tmp/011_customer_conn" || die "cannot open 011 for writing: $!\n";
print C "\n",
        "Group \"Customer Connectivity\" \{\n",
        "\tautogenerated:\tyes\n",
        "\tfrequency:\t300\n",
        "\tnostats:\ttrue\n",
        "\tsiren:\tno\n",
        "\tGroup \"T1\" \{\n";
foreach( @files ){
        next if( /\/\./ || $_ eq "Override" );
        $file=$_;
        $file =~ /.+\/(.+-.+-\d{4}-\d{02})\//;
         $router = $1;

        #print C "\t\tGroup \"$router\" \{\n";
        open F, "$file" || die "cannot open $file: $!\n";
        $/ = '!';
        while( <F> ){
                next if( /shutdown/ );
                if( /interface\s(Serial\d\S+)\n\sdescription\s(.+)\n\sip\saddress\s(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s/ ){
                        $interface=$1;
                        $description=$2;
                        $ourip=$3;

                        next if( $description =~ /\[.*no-monitor.*\]/ );
                        ($oct1,$oct2,$oct3,$oct4) = split /\./, $ourip;
                        # monitor our side if the description has monitor-local inside brackets
                        # (for customers with firewalls/whatever
                        if( $description !~ /\[.*monitor-local.*\]/ ){
                                $oct4++;
                        }

                        $theirip="$oct1.$oct2.$oct3.$oct4";

                        $label=$description;
                        $label =~ s/\[.*\]//;
                        $label =~ s/[Tt]1\s[Tt][Oo]\s//;
                        $label =~ s/T1//;
                        $label =~ s/WAN//;
                        $label =~ s/^\s+//;
                        $label =~ s/\s+$//;
                        $label =~ s/#//;

                        if( ! $label ){ $label = "UNKNOWN" };
                        $label = "[" . "$label" . "]";
                        #print "found int: $interface desc: $description ourip: $ourip theirip: $theirip \n";
                        print C "\t\tService Ping \{\n",
                                "\t\t\tlabel: $label\n",
                                "\t\t\thostname:\t$theirip\n",
                                "\t\t\tnote:\t$router:$interface ($description)\n",
                                "\t\t\tsendnotify: no\n",
                                "\t\t\}\n";
                }
        }
        close F;
        $/ = "\n";
        #print C "\t\t\}\n";
}
print C "\t\}\n",
        "\}\n";
close C;


rename "/export/tmp/011_customer_conn", "/export/home/config/argus/config/011_customer_conn" || die "cannot rename: $!\n";
