# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Apr-03 09:13 (EST)
# Function: config file reading
#
# $Id: Conf.pm,v 1.29 2003/03/04 20:32:07 jaw Exp $

# some bozo put a Config.pm in the standard perl dist
package Conf;

%Config = ();		# misc top level global config data
$has_errors = 0;	# if we found errors, the web page will indicate such (global)
my $Top = undef;	# the Top pseudo-object
my @allfiles = ();	# all of the config files
my $timestamp = 0;	# time we last read the config files

# read the config file(s)
sub readconfig {
    my $file = shift;
    my $me = {};
    my( @files );

    bless $me;
    $timestamp = $^T;
    $Service::n_services = 0;		      # this really doesn't belong here, but...
    # one file or directory of files?
    if( -d $file && -r _ && -x _ ){
	$me->{basedir} = $file;		      # includes will be relative to config dir
	opendir D, $file;
	@files = 
	  grep { !/^[\.\#]/ }		      # skip .file and #file
	  grep { !/(\.bkp|~)$/ } readdir D;   # and file.bkp and file~
	closedir D;
    }else{
	@files = ($file);
    }

    $me->{files} = [sort @files];

    $Top = $me->configure();
}

sub configure {
    my $me = shift;
    my( $top, $o, $nomoredata, @kids );

    $top = Group->new();
    $top->{type} = 'Group';
    $top->{name} = 'Top';
    $top->{i_am_top} = 1;	# used only to pretty print the config

    while( defined( $_ = $me->nextline() ) ){
	print STDERR "  gotline: $_\n" if $::opt_d;
	eval {
	    if( /^(Group|Host)\s/i ){
		$nomoredata = 1;
		$me->ungetline($_);
		$o = Group::readconfig($me, $top);
		push @kids, $o if $o;
	    }
	    elsif( /^Alias\s/i ){
		$nomoredata = 1;
		$me->ungetline($_);
		$o = Alias::readconfig($me, $top);
		push @kids, $o if $o;
	    }
	    elsif( /^Method\s/i ){
		$me->ungetline($_);
	        NotMe::readconfig($me);
	    }
	    elsif( /:/ ){
		my ($k, $v) = split /:\s*/, $_, 2;
		if( $nomoredata ){
		    $me->warning( "additional data not permitted here (ignored)" );
		    next;
		}
		$me->warning( "redefinition of parameter '$k'" )
		    if defined $Config{$k};
		$Config{$k} = $v;
	    }
	    else{
		$me->error( "Huh? This does not look like a vaild config entry: '$_'" );
	    }
	};
	if( $@ ){
	    die $@ if $@ != $me;
	}
    }

    push @{$top->{children}}, @kids;
    $top->config($me);
    
    return if $::opt_t;
    $top->clearcache();        # reclaim memory used by hasattr cache
    eval {
	$top->resolve_alii($me);
    };
    eval {
	$top->resolve_depends($me);
    };
    $top->jiggle();		# update object statuses
    $top->{sort} = 0;     	# top is not sorted
    $top->{overridable} = 0;
    $top->sort_children();

    $top;
}

sub error {
    my $me = shift;
    my $msg = shift;
    my( $m );

    $has_errors = 1;
    $m = "ERROR: ";
    if( $me->{file} ){
	$m .= "in file '$me->{file}' on line $me->{line} - ";
    }
    $m .= $msg;
    ::loggit( $m, 1 );

    die $me;
    undef;
}

sub warning {
    my $me = shift;
    my $msg = shift;
    my( $m );

    $m = "WARNING: ";
    if( $me->{file} ){
	$m .= "in file '$me->{file}' on line $me->{line} - ";
    }
    $m .= $msg;
    ::loggit( $m, 1 );
    undef;
}

sub openfile {
    my $me = shift;
    my $f  = shift;
    my $ff;
    
    $me->{fd} = $fh = BaseIO::anon_fh();
    $me->{file} = undef;
    $me->{line} = undef;
    
    print STDERR "reading config file: $f\n" if $::opt_d;
    eval {
	if( $me->{basedir} && $f !~ m,^/, ){
	    $ff = "$me->{basedir}/$f";
	}else{
	    $ff = $f;
	}
	open( $fh, $ff ) ||
	    $me->error( "'$ff' is stubborn and refuses to open: $!" );
    };
    return undef if $@;
    
    push @allfiles, $ff;
    $me->{file} = $f;
    $me->{line} = 0;
    
    1;
}

sub includefile {
    my $me = shift;
    my $file = shift;

    push @{$me->{openfiles}}, [$me->{fd}, $me->{file}, $me->{line}];
    $me->openfile( $file ) || $me->nextfile();
}

sub nextfile {
    my $me = shift;
    my( $f, $fh );
    $fh = $me->{fd};

    close $fh;

    if( @{$me->{openfiles}} ){
	($me->{fd}, $me->{file}, $me->{line}) = @{ pop @{$me->{openfiles}} };
	return 1;
    }
    
    while(1){
	$f = shift @{$me->{files}};
	print STDERR "next file: $f\n" if $::opt_d;
	return undef unless $f;
	next unless $me->openfile( $f );
	return 1;
    }
}

sub nextline {
    my $me = shift;
    my( $fh, $a );

    if( defined( $a = $me->{prevline} ) ){
	delete $me->{prevline};
	return $a;
    }

    $a = '';
    while(1){
    
	$fh = $me->{fd};
	while( <$fh> ){
	    $me->{line} ++;
	    chop;
	    # need to be able to include a literal # in the config
	    # by saying \# and below convert \# -> #
	    s/\s*(?<!\\)\#.*$//;
	    s/^\s+//;
	    s/\s+$//;
	    next if /^\s*$/;
	    s/\\&//g;
	    s/\\n/\n/g;
	    s/\\r/\r/g;
	    s/\\\#/\#/g;
	    # no, I don't want to s/\\(\.)/$1/
	    # it will mess up regexes
	    
	    # handle include files
	    if( /^include \"(.*)\"/i ){
		$me->includefile( $1 );
		$fh = $me->{fd};
		next;
	    }
	    
	    $a .= $_;
	    if( $a =~ /\\$/ ){
		chop $a;
		next;
	    }
	    return $a;
	}
	$me->nextfile() || return undef;
    }
}

sub ungetline {
    my $me = shift;
    my $line = shift;

    $me->{prevline} = $line;
}

sub check_config_files {
    foreach my $f (@allfiles){
	my $t = (stat($f))[9];
	if( $t > $timestamp ){
	    # the file changed--restart
	    ::loggit( "config file '$f' changed - restarting", 1 );
	    kill 'HUP', $$;
	    last;
	}
    }
}

sub deconfigure {
    %Config = ();
    $Top = undef;
}

# check for changes in config files every 5 minutes
Cron->new(
	  freq => 300,
	  text => 'check config files',
	  func => \&check_config_files,
	  );

1;

