# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Nov-04 14:55 (EST)
# Function: encode/decode text
#
# $Id: Encode.pm,v 1.1 2003/01/28 18:40:06 jaw Exp $

package Encode;

# modification of quoted-printable encoding
# encode chars that will cause problems with webpages, etc
sub encode {
    my $txt = shift;

    $txt =~ s/([ \r\n%\+\\\;=\"\'\`\?\&~<>\/\000-\037\200-\377])/sprintf("~x%02X",ord($1))/ge;
    $txt;
}

# And so of these. Which is the natural man,
# And which the spirit? who deciphers them?
#  -- Shakespeare, Comedy of Errors
sub decode {
    my $txt = shift;

    $txt =~ s/~x(..)/chr(hex($1))/ge;
    $txt;
}

sub import {
    my $pkg = shift;
    my $caller = caller;

    for my $f (qw(encode decode)){
	*{$caller . '::' . $f} = $pkg->can($f);
    }
}
    
1;
