# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Apr-03 08:56 (EST)
# Function: the group class
#
# $Id: Group.pm,v 1.28 2003/02/05 04:25:48 jaw Exp $


package Group;
@ISA = qw(MonEl);

# And then, perchance because his breath was failing,
# He grouped himself together with a bush.
#   -- Dante, Divine Comedy

$doc = {
    package => __PACKAGE__,
    file    => __FILE__,
    isa     => [@ISA],
    conf => {
	quotp => 1,
	bodyp => 1,
    },
    methods => {
    },
    fields => {
    },
};


sub new {
    my $class = shift || 'Group';
    my $x = {};
    bless $x, $class;
    $x;
}

sub config {
    my $me = shift;
    my $cf = shift;
    
    $me->init_from_config( $doc, 'group' );
    return undef unless $me->init( $cf );
}

sub readconfig {
    my $cf  = shift;
    my $mom = shift;
    my $me  = new;
    my( $line, $type, $name, $x, $nomoredata, @kinder );
    
    $me->{parents} = [ $mom ] if $mom;

    $line = $cf->nextline();
    ($type, $name) = $line =~ /(Group|Host)\s+\"(.*)\"/i;
    $me->{type} = "\u\L$type";
    $me->{name} = $name;
    $me->{definedinfile} = $cf->{file};
    $me->{definedonline} = $cf->{line};
    $me->{definedattime} = $^T;

    while( defined($_ = $cf->nextline()) ){
	print STDERR "readgroup: $_\n" if $::opt_d;
	if( /^\s*\}/ ){
	    $me->{children} = [ @kinder ];
	    $me->config($cf);
	    return $me;
	}

	elsif( /^(Group|Host)\s/i ){
	    $nomoredata = 1;
	    $cf->ungetline($_);
	    $x = Group::readconfig($cf, $me);
	    push @kinder, $x if $x;
	}

	elsif( /^Alias\s/i ){
	    $nomoredata = 1;
	    $cf->ungetline($_);
	    $x = Alias::readconfig($cf, $me);
	    push @kinder, $x if $x;
	}

	elsif( /^Service/i ){	# no, not Service\s, we permit a ':' for symmetry
	    $nomoredata = 1;
	    $cf->ungetline($_);
	    $x = Service::readconfig($cf, $me);
	    push @kinder, $x if $x;
	}

	elsif( /:/ ){
	    my($k, $v) = split /:\s*/, $_, 2;
	    # data must be before Service|Group|Alias 
	    # disallow
	    # Group "foo" {
	    #    x1: value
	    #    Service TCP/FOO
	    #    x2: value          <- error
	    # }
	    if( $nomoredata ){
		$cf->warning( "additional data not permitted here (ignored)" );
		next;
	    }
	    $cf->warning( "redefinition of parameter '$k'" )
		if defined $me->{config}{$k};
	    $me->{config}{$k} = $v;
	}

	else{
	    return $cf->error( "invalid entry in config file: '$_'" );
	}
    }

    $me;
}

sub gen_conf {
    my $me = shift;
    my( $k, $c, $r, $rc, $t );

    if( $me->{i_am_top} ){
	foreach $k (sort keys %Conf::Config){
	    next if ($k =~ /^_/) && $Conf::Config{_hide_expr};
	    my $v = $Conf::Config{$k};
	    $v =~ s/\#/\\\#/g;
	    $r .= "$k:\t$v\n";
	}
        $r .= NotMe::gen_confs();
	foreach $c (@{$me->{children}}){
	    $r .= "\n";
	    $r .= $c->gen_conf();
	}
	return $r;
    }

    $r .= $me->SUPER::gen_conf();
    $r;
}

################################################################
# override MonEl virtual methods
################################################################
sub webpage {
    my $me = shift;
    my $fh = shift;
    my $topp = shift;
    my( $k, $v, $kk, $c, $x, %cs );

    print $fh "<!-- start of Group::webpage -->\n";
    
    # object data
    unless( $topp ){
	print $fh "<TABLE CELLSPACING=1>\n";
	foreach $k (qw(name ovstatus flags info note comment annotation details)){
	    $v = $me->{$k};
	    $kk = $k;
	    $x = '';
	    if( $k eq 'ovstatus' ){
		$x = " BGCOLOR=\"" . MonEl::web_color($v) . "\"";
		$kk = 'status';
	    }
	    print $fh "<TR><TD>$kk</TD><TD$x>$v</TD></TR>\n" if defined($v);
	    if( $k eq 'ovstatus' && $me->{depend}{culprit} ){
		# QQQ - is this really how I want to do it?
		print $fh "<TR><TD>...because</TD><TD>$me->{depend}{culprit} is down</TD></TR>\n";
	    }
	    
	}
	print $fh "</TABLE>\n";

	$me->web_override($fh);
	print $fh "<HR>\n";
    }
    
    # children status
    if( @{$me->{children}} ){
	print $fh "<TABLE>\n";
	if( $topp ){
	    print $fh "<TR><TH>Name</TH><TH>Up</TH><TH>Down</TH><TH>Override</TH></TR>\n";
	    foreach $c (@{$me->{children}}){
		$c->web_page_row_top($fh);
	    }
	}else{
	    print $fh "<TR><TH>Name</TH><TH COLSPAN=3>Status</TH></TR>\n";
	    foreach $c (@{$me->{children}}){
		$c->web_page_row_base($fh);
	    }
	}
	print $fh "</TABLE>\n";
    }
    else{
	print $fh "<!-- no children -->\n";
    }
    
    print $fh "<!-- end of Group::webpage -->\n";
}


sub web_page_row_base {
    my $me = shift;
    my $fh = shift;
    my $label = shift;
    my( $kov, $color, $c, $s, %cs );

    return if $me->{web}{hidden};
    foreach $c (@{$me->{children}}){
	my $cc = $c;
	$cc = $c->aliaslookup() if $c->can('aliaslookup');
	$kov = 1 if $c->{override};

	my $st = $cc->{ovstatus};
	my $xx = '';
	if( $st !~ /^(up|down|override)$/ ){
	    $st = 'down';
	    $xx = ' <B>*</B>';
	}
	push @{$cs{ $st }},
	    "<A HREF=\"". $c->url('func=page'). "\"><FONT COLOR=\"#000000\">".
		($c->{label_right}||$c->{name}).
		"$xx</FONT></A>"
    }

    if( $me->{override} ){
	$color = ' BGCOLOR=' . MonEl::web_color('override');
    }
    print $fh "<TR><TD$color><A HREF=\"", $me->url('func=page'), "\">",
        ($label||$me->{label_left}||$me->{name}), "</A></TD>";

    foreach $s ('up', 'down', 'override'){
	my $cx = join( " &nbsp; ", @{$cs{$s}});
	if( $cx ){
	    print $fh "<TD BGCOLOR=\"", MonEl::web_color($s), "\">$cx</TD>\n";
	}else{
	    print $fh "<TD></TD>";
	}
    }
    print $fh "</TR>\n";
}

################################################################

Doc::register( $doc );
1;
