# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Apr-03 18:59 (EST)
# Function: testing of SNMP things
#
# $Id: SNMP.pm,v 1.23 2003/04/04 19:28:48 jaw Exp $

package SNMP;
use BER;
use Encode;

@ISA = qw(UDP);

my $snmpid = rand( 1000000 );
sub get_request  { 0 | context_flag };

my %oids =
(
 AdminStatus   => '.1.3.6.1.2.1.2.2.1.7',
 OperStatus    => '.1.3.6.1.2.1.2.2.1.8',
 ifInErrors    => '.1.3.6.1.2.1.2.2.1.14',
 ifOutErrors   => '.1.3.6.1.2.1.2.2.1.20',
 ifInOctets    => '.1.3.6.1.2.1.2.2.1.10',
 ifOutOctets   => '.1.3.6.1.2.1.2.2.1.16',
 BGPPeerStatus => '.1.3.6.1.2.1.15.3.1.2',
 ciscoEnvMonTemperatureStatusValue => '.1.3.6.1.4.1.9.9.13.1.3.1.3',
 # yeah, it is much shorter tp type 'ciscoEnvMonTemperatureStatusValue' ...

 );

$doc = {
    package => __PACKAGE__,
    file    => __FILE__,
    isa     => [qw(UDP Service MonEl BaseIO)],
    methods => {},
    html   => 'services',
    fields => {
      snmp::community => {
	  descr => 'SNMP community',
	  attrs => ['config', 'inherit'],
      },
      snmp::oid => {
	  descr => 'SNMP OID to query',
	  attrs => ['config'],
      },
      snmp::snmpcalc => {
	  descr => 'deprecated, use calc instead',
	  attrs => ['config'],
	  versn => '3.2',
      },
    },
};

sub probe {
    my $name = shift;

    return ( $name =~ /^UDP\/SNMP/ ) ? [ 8, \&config ] : undef;
}

sub config {
    my $me = shift;
    my $cf = shift;

    bless $me;
    $me->init_from_config( $doc, 'snmp' );
    
    if( $me->{name} =~ /SNMP\/(.*)/ ){
	$me->{snmp}{oid} ||= $1;
    }

    $cf->warning( 'snmpcalc was renamed calc' )
	if $me->{snmp}{snmpcalc};
    
    $me->{label_right_maybe} ||= $me->{snmp}{oid};
    $me->SUPER::config($cf);
    $me->{udp}{port} ||= 161;
    $me->{snmp}{alpha} = 1 unless $me->{snmp}{alpha} > 0;
    $me->snmp_init($cf);
    $me->{uname} = "SNMP_$me->{snmp}{oid}_$me->{udp}{hostname}";
    $me;
}

sub snmp_init {
    my $me = shift;
    my $cf = shift;
    my( $req, $oid );

    $oid = $me->{snmp}{oid};

    return $cf->error( "invalid OID ($oid)" )
	unless $oid;

    $oid =~ s/([^\d\.]+)/$oids{$1}||'UNKNOWN'/ge;
    
    return $cf->error( "invalid OID ($oid)" )
	unless( $oid =~ /^[\d\.]+$/ );

    $me->{snmp}{oid} = $oid;
    
    # Why lifts she up her arms in sequence thus?
    #   -- Shakespeare, Titus Andronicus
    # SNMP v1 packet
    $req = encode_sequence( encode_int_0,
		    encode_string( $me->{snmp}{community} ), 
		    encode_tagged_sequence(
				   get_request,
				   encode_int( $snmpid++ ),
				   encode_int_0,
				   encode_int_0,
				   encode_sequence(
					   encode_sequence(
						   encode_oid(split /\./, $oid ),
						   encode_null()))) );
    $me->{udp}{send} = $req;
    $me;
}

sub readable {
    my $me = shift;
    my( $fh, $i, $l );

    $fh = $me->{fd};
    $i = recv($fh, $l, 8192, 0);
    return $me->isdown( "SNMP recv failed: $!" )
	unless defined($i);

    $me->debug( "SNMP recv data" );
    $me->{udp}{rbuffer} = $l;		# for debugging

    $BER::errmsg = '';
    
    my( $ver, $comm, $reqid, $errst, $errin, $oid, $value ) =
	decode_by_template($l, "%{%i%s%*{%i%i%i%{%{%O%@", 162 );

    $value = pretty_print($value);

    if( $BER::errmsg ){
	return $me->isdown( "BER error: $BER::errmsg" );
    }

    if( $value eq "(null)" ){
	return $me->isdown( "BER error: NULL (no such OID?)" );
    }
    
    $me->debug( "SNMP recv - raw value $value" );
    $me->generic_test($value, 'SNMP');
}

sub webpage_more {
    my $me = shift;
    my $fh = shift;
    my( $k, $v );
    
    $me->SUPER::webpage_more($fh);
    
    foreach $k (qw(oid)){
	$v = $me->{snmp}{$k};
	print $fh "<TR><TD>SNMP $k</TD><TD>$v</TD></TR>\n" if defined($v);
    }
}

sub about_more {
    my $me = shift;
    my $ctl = shift;
    my( $k, $v );

    $me->SUPER::about_more($ctl);
    $me->more_about_whom($ctl, 'snmp');
}


Doc::register( $doc );
push @Service::probes, \&probe;

1;
