# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Nov-06 18:03 (EST)
# Function: monitor various system values via an agent
#
# $Id: SysAgent.pm,v 1.8 2003/04/04 19:28:48 jaw Exp $

package SysAgent;
use Encode;

@ISA = qw(TCP);
$doc = {
    package => __PACKAGE__,
    file    => __FILE__,
    isa     => [qw(Service MonEl BaseIO)],
    methods => {},
    versn  => '3.2',
    fields => {
      sys::param => {
	  descr => 'the parameter to fetch (uptime, load, ...)',
	  attrs => ['config'],
      },
      sys::arg => {
	  descr => 'optional arguement',
	  attrs => ['config'],
      },
    },
};

my $SYS_PORT = 164;

sub probe {
    my $name = shift;

    return ( $name =~ /^SYS/ ) ? [ 3, \&config ] : undef;
}

sub config {
    my $me = shift;
    my $cf = shift;
    my( $l );
    
    bless $me;
    $me->init_from_config( $doc, 'sys' );
    
    if( $me->{name} =~ /SYS\/(.*)/ ){
	$me->{sys}{param} ||= $1;
    }
    
    return $cf->error("no agent param specified")
	unless $me->{sys}{param};
    
    $me->{tcp}{send} = $me->{sys}{param};
    $me->{tcp}{send} .= " " . $me->{sys}{arg} if $me->{sys}{arg};
    $me->{tcp}{send} .= "\n";
    $me->{tcp}{port} = $SYS_PORT;
    $me->{tcp}{readhow} = 'toeof';
    
    $l = $me->{tcp}{send};
    chop( $l );
    $l =~ s/\s+/_/g;
    $me->{label_right_maybe} = $l;
    #...
    $me->SUPER::config($cf);
    $me->{uname} = "SYS_$me->{tcp}{hostname}_$l";

}

sub test {
    my $me = shift;
    my $v  = $me->{tcp}{rbuffer};
    
    chomp($v);
    $me->generic_test( $v );
}

sub about_more {
    my $me = shift;
    my $ctl = shift;
    my( $k, $v );

    $me->SUPER::about_more($ctl);
    $me->more_about_whom($ctl, 'sys');
}

    
################################################################
# global config
################################################################
Doc::register( $doc );
push @Service::probes, \&probe;

1;
