# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Apr-03 15:59 (EST)
# Function: testing of TCP services
#
# $Id: TCP.pm,v 1.39 2003/04/14 16:33:55 jaw Exp $


package TCP;
@ISA = qw(Service);
use Encode;
use Fcntl;
use Socket;
use POSIX qw(:errno_h);
BEGIN {
    eval { require Socket6; import Socket6; };
}

$doc = {
    package => __PACKAGE__,
    file    => __FILE__,
    isa     => [qw(Service MonEl BaseIO)],
    methods => {},
    html   => 'services',
    fields => {
      tcp::hostname => {
	  descr => 'hostname or IP address to test',
	  attrs => ['config', 'inherit'],
      },
      tcp::port => {
	  descr => 'TCP port to test',
	  attrs => ['config'],
      },
      tcp::addr => {
	  descr => 'encoded IP address',
      },
      tcp::srcaddr => {
	  descr => 'local IP address',
	  attrs => ['config', 'inherit'],
	  versn => '3.2',
      },
      tcp::srcip => {
	  descr => 'encoded local IP address',
      },
	
      tcp::send => {
	  descr => 'text to send once connected',
	  attrs => ['config'],
      },
      tcp::url => {
	  descr => 'url to check',
	  attrs => ['config'],
	  exmpl => 'http://www.example.com/cgi-bin/shopping.pl',
      },
      tcp::browser => {
	  descr => 'browser spoofing for URL checks',
	  attrs => ['config', 'inherit'],
	  exmpl => 'Mozilla/1.0 (compatible; MSIE 1.0; Windblows 19100; Argus Test)',
      },
      tcp::referer => {
	  descr => 'referer spoofing for URL checks',
	  attrs => ['config', 'inherit'],
	  versn => '3.2',
	  exmpl => 'http://argus.tcp4me.com/',
      },
	
      tcp::readhow => {
	  descr => 'how much data should be read from the server before checking expect',
	  attrs => ['config'],
	  vals  => ['banner', 'toeof', 'once'],
      },
      tcp::altsend => {
	  descr => 'text to send once connected, instead of normal value',
	  # used by redirect handler
      },
      tcp::rbuffer => {
	  descr => 'read buffer',
      },
      tcp::wbuffer => {
	  descr => 'write buffer',
      },
      tcp::redircount => {
	  descr => 'number of times we have gotten an HTTP redirect',
	  # to do simplistic redirect loop detection
      },
    },

};

%config =
(

 SMTP   => {
     # send   => "MAIL\r\n",  # not RFC compliant, but quiets sendmails logs
     port   => 25,	expect => '^220',	readhow => "banner",
 },
 
 FTP    => {
     port   => 21,	expect => '^220',	readhow => "banner",
 },
	   
 POP    => {
     port   => 110,	expect => '^\+OK',	readhow => "banner",
 },
 
 NNTP   => {
     port   => 119,	expect => '^200',	readhow => "banner",
 },
	   
 HTTP   => {
     port   => 80,
     # send gets built below
     expect => "HTTP/",				readhow => "toeof",
 },

 # this is different than HTTP--it tests the content of a page
 # and will follow (to limited extent) http redirects
 # and can do browser spoofing (browser: Mozilla/4.0...)
 URL   => {
     expect => "HTTP/[0-9\.]+ 200",		readhow => 'toeof',
 },
 
 Telnet => {
     port => 23,
 },

 Gopher => {
     port => 70,
     send => "\r\n",
     expect  => "\.\r\n",			readhow => 'toeof',
 },
 
 SSH => {
     port => 22, expect => '^SSH',              readhow => 'banner',
 },

 IMAP => {
     port => 143, expect => '^* OK',            readhow => 'banner',
 },

 SSL => {
     port => 443,
 },
 HTTPS => {
     port => 443,
 },

 Whois => {
     port => 43, send => "\r\n",
 },
 
 
 );

# what? like this might change?
my $PROTO_TCP = getprotobyname('tcp');

sub probe {
    my $name = shift;

    return ( $name =~ /^TCP/ ) ? [ 3, \&config ] : undef;
}

sub config {
    my $me = shift;
    my $cf = shift;
    my( $name );

    $name = $me->{name};
    $name =~ s/^TCP\/?//;

    $me->{tcp}{port}         ||= $config{$name}{port};
    $me->{tcp}{send}         ||= $config{$name}{send};
    $me->{test}{expect}      ||= $config{$name}{expect};
    $me->{tcp}{readhow}      ||= $config{$name}{readhow};
    
    $me->{label_right_maybe} ||= $name;
    
    $me->init_from_config( $doc, 'tcp' );

    if( $name eq 'HTTP' ){
	my $http = http_request($me);
	$me->{tcp}{send}   ||= "HEAD / HTTP/1.0\r\n$http\r\n";
    }
    if( $name eq 'URL' ){
	my( $host, $port, $file ) = $me->{tcp}{url} =~ m|http://([^:/]+)(?::([^/]+))?(/.*)?|;
	$me->{tcp}{port} = $port ||= 80;
	$file ||= '/';
	# we permit the hostname that we connect to be different that the hostname in the url
	# this permits testing "hidden" virtual servers or proxies
	# ie: we connect to hostname, we send the host in the URL as the Host header
	# QQQ - I'm not sure if this is useful, though
	$me->{tcp}{hostname} = $host;
	#      unless $me->{tcp}{hostname}; # comment out this line, to revert to previous behaviour
	# commented back out for backwards compatibility
	$me->{uname} = "URL_$host:$port$file";
	unless( $host ){
	    return $cf->error( 'invalid URL' );
	}
	my $http = http_request($me);
	$me->{tcp}{send}   = "GET $file HTTP/1.1\r\nHost: $host:$port\r\n$http\r\n";
    }else{
	if( $name ){
	    $me->{uname} = "${name}_$me->{tcp}{hostname}";
	}else{
	    $me->{uname} = "TCP_$me->{tcp}{port}_$me->{tcp}{hostname}";
	}
    }
    
    $me->{tcp}{addr} = ::resolve( $me->{tcp}{hostname} );
    unless( $me->{tcp}{addr} ){
	return $cf->error( "cannot resolve host $me->{tcp}{hostname}" );
    }

    unless( $me->{tcp}{port} ){
	return $cf->error( "Incomplete specification or unknown protocol for Service $name" );
    }

    if( $me->{tcp}{srcaddr} ){
	$me->{tcp}{srcip} = ::resolve($me->{tcp}{srcaddr});
	$cf->warning( "Cannot resolve $me->{tcp}{srcaddr}" ) unless $me->{tcp}{srcip};
    }
    
    bless $me if( ref($me) eq 'Service' );

    $me;
}

sub http_request {
    my $me = shift;
    
    # build http request
    my $http = "Connection: close\r\n";
    $http .= "User-Agent: $me->{tcp}{browser}\r\n" if $me->{tcp}{browser};	
    $http .= "Referer: $me->{tcp}{referer}\r\n"    if $me->{tcp}{referer};
    # to assist in debugging...
    $http .= "X-Argus-Version: $::VERSION\r\n";
    $http .= "X-Argus-URL: $::ARGUS_URL\r\n";
    $http;
}

sub start {
    my $me = shift;
    my( $i, $fh, $ip, $ipv );

    $me->{fd} = $fh = BaseIO::anon_fh();
    $ip = $me->{tcp}{addr};
    $me->Service::start();

    if( length($ip) == 4 ){
	$i = socket($fh, PF_INET, SOCK_STREAM, $PROTO_TCP);
    }else{
	$i = socket($fh, PF_INET6, SOCK_STREAM, $PROTO_TCP);
	$ipv = ' IPv6';
    }
    unless($i){
	my $m = "socket failed: $!";
	::sysproblem( "TCP $m" );
	$me->debug( $m );
	return $me->done();
    }
    $me->baseio_init();

    if( $me->{tcp}{srcip} ){
	my $srcip = $me->{tcp}{srcip};
	if( length($srcip) == 4 ){
	    $i = bind( $fh, sockaddr_in(0, $srcip) );
	}else{
	    $i = bind( $fh, pack_sockaddr_in6(0, $srcip) );
	}
	unless($i){
	    my $m = "bind failed: $!";
	    ::sysproblem( "TCP $m" );
	    $me->debug( $m );
	    return $me->done();
	}
    }
    
    alarm(3);
    # in some cases this may block, even though we set non-blocking
    if( length($ip) == 4 ){
	$i = connect( $fh, sockaddr_in($me->{tcp}{port}, $ip) );
    }else{
	$i = connect( $fh, pack_sockaddr_in6($me->{tcp}{port}, $ip) );
    }
    alarm(0);
    unless( $i || $! == EALREADY || $! == EINPROGRESS ){
	# some OSes will not re-report the error in the SO_ERROR query below...
	return $me->isdown( "TCP connect failed: $!" );
    }
    # if the connect fails for other reasons, we get the error in writable()
    
    $me->{srvc}{state} = 'connecting';
    $me->wantread(0);
    $me->wantwrit(1);
    $me->settimeout( $me->{srvc}{timeout} );
    $me->{tcp}{rbuffer} = '';
    $me->{tcp}{wbuffer} = '';
    undef $me->{tcp}{redircount};
    
    $me->debug( "TCP Start: connecting -$ipv tcp/$me->{tcp}{port}, ".
		"$me->{tcp}{hostname}, try $me->{srvc}{tries}" );
}

sub timeout {
    my $me = shift;
    $me->isdown( "TCP timeout: $me->{srvc}{state}" );
}

sub http_redirect {
    my $me = shift;
    my( $url, $file, $loc );

    # NB: this code path never calls done
    $me->shutdown();
    
    ($loc) = grep /^Location:/, split( /\n/, $me->{tcp}{rbuffer} );
    $loc =~ tr/\r//d;
    ($url) = $loc =~ /^Location:\s+(.*)/;
    ($file) = $url =~ /http:\/\/[^\/]*(.*)/;
    # NB: cannot redirect to another host
    
    $me->{tcp}{altsend}  = "GET $file HTTP/1.1\r\nHost: $me->{tcp}{hostname}:$me->{tcp}{port}\r\n";
    $me->{tcp}{altsend} .= $me->http_request();
    $me->{tcp}{altsend} .= "\r\n";
    $me->debug( "HTTP Redirect -> $url" );
    if( ++$me->{tcp}{redircount} > 15 ){
	return $me->isdown( 'HTTP Redirect Loop' );
    }
    # start over without rescheduling
    $me->start();
}

sub writable {
    my $me = shift;

    if( $me->{srvc}{state} eq 'connecting' ){
	my $fh = $me->{fd};
	my $i = unpack('L', getsockopt($fh, SOL_SOCKET, SO_ERROR));
	if( $i ){
	    $! = $i;
	    # QQQ, should I try to sort out errors, down on some, sysproblem on others?
	    return $me->isdown( "TCP connect failed: $!" );
	}
	
	$me->debug( 'TCP - connected' );
	$me->{tcp}{wbuffer} = $me->{tcp}{altsend} || $me->{tcp}{send};
	undef $me->{tcp}{altsend};
	$me->{srvc}{state} = 'sending';
	$me->settimeout( $me->{srvc}{timeout} );
    }
    
    if( $me->{tcp}{wbuffer} ){
	my( $b, $i, $l, $fh );

	$fh = $me->{fd};
	$b = $me->{tcp}{wbuffer};
	$l = length($b);
	# And he asked for a writing table, and wrote
	#   -- Luke 1:63
	$i = syswrite $fh, $b, $l;
	if( $i ){
	    $me->debug( "TCP - wrote $i bytes of $l" );
	}else{
	    return $me->isdown( "TCP write failed: $!" );
	}
	$b = substr( $b, $i, $l );
	$me->{tcp}{wbuffer} = $b;
    }
    
    if( !$me->{tcp}{wbuffer} ){
	if( $me->{tcp}{readhow} ){
	    $me->{srvc}{state} = 'expecting';
	    $me->wantread(1);
	    $me->wantwrit(0);
	    $me->settimeout( $me->{srvc}{timeout} );
	}else{
	    # success is a connected socket
	    $me->isup();
	}
    }
}

sub readable {
    my $me = shift;
    my( $fh, $i, $l, $testp );

    $fh = $me->{fd};
    $i = sysread $fh, $l, 8192;
    # And this is the writing that was written: MENE, MENE, TEKEL, UPHARSIN.
    #   -- daniel 5:25
    if( $i ){
	$me->debug( 'TCP - read data' );
	$me->{tcp}{rbuffer} .= $l;
    }
    elsif( defined($i) ){
        # And it came to pass, when Moses had made an end of writing ...
	#   -- dueteronomy 31:24
	# $i is 0 -> eof
	$me->debug( 'TCP - read eof' );
	$testp = 1;
    }
    else{
	# $i is undef -> error
	return $me->isdown( "TCP read failed: $!" );
    }

    if( $me->{tcp}{readhow} eq 'banner' && $me->{tcp}{rbuffer} =~ /\n/ ){
	# My ears have not yet drunk a hundred words
	# Of that tongue's utterance, yet I know the sound:
	#   -- Shakespeare, Romeo+Juliet
	$testp = 1;
    }
    elsif( $me->{tcp}{readhow} eq 'once' ){
	$testp = 1;
    }
    elsif( $me->{tcp}{readhow} eq 'toeof' ){
	# $testp = 0;
    }
    elsif( length($me->{tcp}{rbuffer}) >= $me->{tcp}{readhow} ){
	# if readhow is a number, read at least that many bytes
	$testp = 1;
    }
    if( $testp ){
	return $me->test();
    }else{
	# kibbles and bits, kibbles and bits, give me more kibbles and bits
	#   -- Dog Food Commercial
	$me->wantread(1);
	$me->wantwrit(0);
    }
}

sub test {
    my $me = shift;
    my( $e );
    
    if( $me->{name} eq 'TCP/URL' && $me->{tcp}{rbuffer} =~ /HTTP\/1\.\d+\s+30[12]/ ){
	# once or twice she had peeped into the book her sister was reading, but
	# it had no pictures or conversations in it,
	#   -- Alice in Wonderland
	# try to handle redirect
	return $me->http_redirect();
    }
    
    # There is a written scroll! I'll read the writing.
    #   -- Shakespeare, Merchant of Venice

    return $me->generic_test($me->{tcp}{rbuffer});
    
}


################################################################
# and also object methods
################################################################

sub about_more {
    my $me = shift;
    my $ctl = shift;

    $me->Service::about_more($ctl);
    $me->more_about_whom($ctl, 'tcp');
}

sub webpage_more {
    my $me = shift;
    my $fh = shift;
    
    foreach my $k (qw(hostname port url)){
	my $v = $me->{tcp}{$k};
	next unless defined $v;
	# I see a lot of long URLs...
	if( $k eq 'url' ){
	    my $c = $v;
	    $c = substr($c, 0, 70) . '...'
		if( length($c) > 70 );
	    $v = qq{<A HREF="$v">$c</A>};
	}
	print $fh "<TR><TD>$k</TD><TD>$v</TD></TR>\n";
    }
}

    
################################################################
# global config
################################################################
Doc::register( $doc );
push @Service::probes, \&probe;



1;
