# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Dec-20 13:06 (EST)
# Function: scalar localtime replacement
#
# $Id: loctime.pl,v 1.2 2003/01/28 14:27:48 jaw Exp $

use POSIX ('strftime');

# localtime does not use locale, strftime does
sub xxx_localtime {
    my $t = shift || $^T;

    # RSN - 
    # $ENV{TZ} = ...
    # $ENV{LC_TIME} = ...
    
    strftime "%a %e %b %T %Y", localtime($t);
}

1;
