# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Apr-02 11:06 (EST)
# Function: misc code
#
# $Id: misc.pl,v 1.23 2003/04/06 18:17:33 jaw Exp $

use Socket;
BEGIN{ eval{ require Socket6; import Socket6; $HAVE_S6 = 1; }}

# My lord the emperor, resolve me this:
#  -- Shakespeare, Titus Andronicus
# memoized gethostbyname
my %resolve = ();
sub resolve {
    my $a = shift;
    my( $ip, @o );

    # skip DNS lookups if only checking the config file (-t)
    # but do the lookup under more checking (-T)
    return "addr" if $::opt_t && !$::opt_T;

    # since we often monitor several things per host, we tend to do lookup
    # each host many times, we use a cache to speed things up
    return $resolve{$a} if( $resolve{$a} );
    
    if( $a =~ /^\d+\.\d+\.\d+\.\d+$/ ){
	$ip = inet_aton( $a );
    }elsif( $HAVE_S6 ){
	# no (easy) way to handle scope-id,
	# would need to use getaddrinfo() and change interface to resolve
	$ip = inet_pton(AF_INET, $a) || inet_pton(AF_INET6, $a);
	if( length($ip) == 0 ){
	    sleep 1;
	    $ip = inet_pton(AF_INET, $a) || inet_pton(AF_INET6, $a);
	}
    }else{
        $ip = gethostbyname($a);
        if( length($ip) != 4){
	    # if the lookup fails, we briefly pause and try again
	    # this takes care of slow DNS servers or transient errors
            sleep 1;
            $ip = gethostbyname($a);
        }
    }
    $resolve{$a} = $ip;
    $ip;
}

sub xxx_inet_ntoa {
    my $n = shift;

    return inet_ntoa($n) if length($n) == 4;
    return undef unless $HAVE_S6;
    inet_ntop(AF_INET6, $n);
}

sub ckbool {
    my $v = shift;

    ($v =~ /yes|true|on|1/i) ? 1 : 0;
}


# And these does she apply for warnings, and portents,
# And evils imminent; and on her knee
#  -- Shakespeare, Julius Ceasar
sub warning {
    my $msg = shift;

    loggit( $msg, 1 );
}

sub xxx_openlog {
    if( $Conf::Config{syslog} ){
	print STDERR "opening syslog: $Conf::Config{syslog}\n" if $::opt_f;
	$ENV{ARGUS_SYSLOG} = $Conf::Config{syslog};
	eval {
	    # this is only in $VER > $X
	    setlogsock( 'unix' );
	};
	openlog( $NAME, 'pid ndelay', $Conf::Config{syslog} );
    }
}

# And there was found at Achmetha, in the palace that is in the province
# of the Medes, a roll, and therein was a record thus written:
#   -- ezra 6:2
sub loggit {
    my $msg = shift;
    my $lfp = shift;
    my( $date, @d );

    # When they had thrown down their great logs of wood over the whole ground
    #   -- Homer, Iliad
    @d = localtime;
    $date = sprintf "%d/%d/%d %d:%0.2d:%0.2d",
        $d[5]+1900, $d[4]+1, $d[3], $d[2], $d[1], $d[0];

    eval {
	syslog( 'info', $msg )  if $Conf::Config{syslog};
    };
    print STDERR "[$date] $msg\n"   if $opt_f;
    
    Control::console( $msg );
    if( $lfp && $datadir && !$opt_t ){
	if( open  LOG, ">> $datadir/log" ){
	    print LOG "[$date] [$$] $msg\n";
	    close LOG;
	}else{
	    loggit( "open log failed: $!", 0 );
	}
    }
}

sub sysproblem {
    my $msg = shift;

    warning( $msg );
}

sub trace {

    for my $i (0..6){
	print STDERR "trace: ", join(", ", caller($i)), "\n" if caller($i);
    }
    print STDERR "----\n";
}

1;
