#!__PERL__
# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Nov-01 11:54 (EST)
# Function: lay paint on canvas. make pretty graphs.
#
# $Id: picasso.pl,v 1.8 2003/02/10 17:38:35 jaw Exp $

# Computers are useless. They can only give you answers.
#   -- Picasso

use lib('__LIBDIR__');
require "conf.pl";
use Image;
use GraphData;
use Getopt::Std;
getopts('bBc:C:gGlr:s:S:t:Tw:x:y:');

$which = $opt_w;
$size  = $opt_s;
binmode STDOUT;
$| = 1;

$img = Image->new( $size );
$img->transparent() if $opt_T;
$img->border()      if $opt_B;
$img->logscale()    if $opt_l;  # NYI
$img->usebinary()   if $opt_b;
$img->usecolors($opt_c) if $opt_c;
$img->usegrid()     if $opt_g;


if( @ARGV > 1 ){
    $mode2 = 'line';
}else{
    $mode2 = $which eq 'samples' ? 'filled' : 'line';
}
$mode1 = $which eq 'samples' ? '' : $opt_S;
$mode1 = '' if $mode1 eq 'none';

# We first survey the plot, ...
foreach my $n (@ARGV){
    my $m = GraphData->new($n);
    push @us, $m;
    if( $which eq 'samples' ){
	$m->readsamples();
	$img->analyze_samples( $m->{samples} );
    }else{
	$m->readsummary( $which, 576 );	# max 576 points (~ 3 weeks)
	$img->analyze_summary( $m->{samples} );
    }
}

$img->setrange( $opt_r ) if $opt_r;
$img->clabels($opt_C, scalar(@ARGV)) if $opt_C;
$img->xlabel( $opt_x ) if $opt_x;	# draw our labels and titles 1st
$img->ylabel( $opt_y ) if $opt_y;	# we'll move the axii if needed
$img->title(  $opt_t ) if $opt_t;
$img->makeroom()       if $mode1;
$img->ytics();				# this will also move the axii
$img->xtics();
$img->axii();
$img->drawgrid() unless $opt_G;

#..., then draw the model;
#   -- Shakespeare, King Henry IV
if( $mode1 ){
    foreach my $m (@us){
	$img->draw( $mode1, $m->{samples} );
    }
}
foreach my $m (@us){
    $img->draw( $mode2, $m->{samples} );
}

$img->drawgrid() if $opt_G;

print $img->png();
exit 0;

sub error {
    my $msg = shift;
    my $im;

    print STDERR "picasso: ERROR $msg\n";
    
    $im = new GD::Image(160, 64);
    my $blk = $im->colorAllocate(0,0,0);
    my $red = $im->colorAllocate(0xFF,0x88,0x88);

    $im->filledRectangle(0,0, 159,63, $red);
    $im->rectangle(0,0, 159,63, $blk);
    $im->string(GD::gdMediumBoldFont, 4, 2, 'PICASSO: GRAPH ERROR', $blk);
    my @a = grep {$_ || ()} split /(.{25})/, $msg;
    my $y = (@a > 1) ? 16 : 40;
    foreach (@a){
	s/^\s+//;
	$im->string(GD::gdSmallFont, 4, $y, $_, $blk);
	$y += 10;
    }
    
    print $im->png();

    exit -1;
}

