#!/usr/local/bin/perl
# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Nov-06 17:57 (EST)
# Function: remote system monitoring agent
#
# $Id: sys_agent.pl,v 1.5 2002/12/25 21:42:29 jaw Exp $

# run from inetd.conf

# uptime, disk used %, load ave, mailq, etc.
# shouldn't people be running snmpd instead?

# many of these use highly non-portable means for gathering data
# it probably won't work on your system without customization

chop($line = <STDIN>);
($what, $arg) = split /\s+/, $line, 2;

if( $what eq 'load' ){
    if( open(F, "/proc/loadavg") ){
	# linux
	my $l = <F>;
	($l) = split /\s+/, $l;
	print "$l\n";
	close F;
    }elsif( open(F, "/kern/loadavg") ){
	# netbsd
	my $l = <F>;
	my(@a) = split /\s+/, $l;
	$l = $a[0] / $a[3];
	print "$l\n";
	close F;
    }else{
	# other
	my $up = output_of_command( 'uptime' );
	$up =~ s/.*:\s*([\d\.]+).*\n?/$1/;
	print "$up\n";
    }
}

if( $what eq 'uptime' ){
    if( open(F, "/proc/uptime") ){
	# linux
	my $l = <F>;
	($l) = split /\s+/, $l;
	print "$l\n";
	close F;
    }elsif( open(F, "/kern/boottime") ){
	# netbsd
	my $l = <F>;
	$l = $^T - $l;
	print "$l\n";
	close F;
    }else{
	# QQQ
	# the format of uptime varies significantly, I am too lazy
	# to write the code at the moment
    }
}

if( $what eq 'disk' ){
    # reasonably standard
    my $df = output_of_command( 'df', $arg );
    $df =~ s/.*\s+(\d+)%.*\n?/$1/s;
    print "$df\n";
}

if( $what eq 'mailq' ){
    
}

if( $what eq 'netstat' ){
    # arg: interface [in|out]
    # extremely non-portable
    my( $int, $dir ) = split /\s+/, $arg;
    my $st = output_of_command( 'netstat', '-b', '-I', $int );
    chop($st);
    $st =~ s/.*\n//s;
    my @st = split /\s+/, $st;
    print $st[ ($dir eq 'in') ? 4 : 5 ], "\n";
}

sub output_of_command {
    my $cmd = shift;
    my @arg = @_;
    my( $f );

    # we don't just `$cmd $arg` in case we have a naughty $arg...
    open(F, "-|") || exec($cmd, @arg);
    while( <F> ){
	$f .= $_;
    }
    close F;
    $f;
}

