# -*- perl -*-

# Copyright (c) 2003 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2003-Sep-12 18:30 (EDT)
# Function: run things at a specified time
#
# $Id: UserCron.pm,v 1.3 2004/02/01 20:17:47 jaw Exp $

# replacement for using a system cronjob to run argusctl

package UserCron;
@ISA = qw(BaseIO Configable);

use strict;
use vars qw(@ISA $doc);

$doc = {
    package => __PACKAGE__,
    file    => __FILE__,
    isa     => [ ],
    methods => {},
    versn   => '3.3',
    html    => 'cron',
    conf => {
	quotp => 1,
	bodyp => 1,
	notypos => 1,
    },
    fields  =>  {

    },
};

sub config {
    my $me = shift;
    
    # $me->init_from_config($doc, '');

    Cron->new( spec => $me->{name},
	       text => 'user cron job',
	       func => \&cronjob,
	       args => $me,
	       );
    $me;
}


# And the LORD said unto Satan, Hast thou considered my servant Job
#   -- Job 1:8
sub cronjob {
    my $me = shift;

    # run argusctl function
    Control::func( $me->{config}{func},
		   ($me->{parents} ? (object => $me->{parents}[0]->unique()) : ()),
		   user => '*internal-cronjob*',
		   %{$me->{config}} );
}

# cron "spec" { ... }
sub readconfig {
    my $cf = shift;
    my $mom = shift;
    my $me = {};

    bless $me;
    my $line = $cf->nextline();
    my($name) = $line =~ /^cron\s+\"(.*)\"/i;
    $me->{name} = $name;
    $me->{type} = 'cron';
    $me->{definedinfile} = $cf->{file};
    $me->{definedonline} = $cf->{line};
    $me->{parents} = [ $mom ] if $mom;
    
    while( defined($_ = $cf->nextline()) ){
	print STDERR "  gotline: $_\n" if $::opt_d;
	if( /^\s*\}/ ){
	    # done
	    last;
	}
	elsif( /:/ ){
	    my($k, $v) = split /:\s*/, $_, 2;
	    $cf->warning( "redefinition of parameter '$k'" )
		if defined $me->{config}{$k};
	    $me->{config}{$k} = $v;
	}
	else{
	    return $cf->error( "invalid entry in config file: '$_'" );
	}
    }

    unless($me->{config}{func}){
	eval{ $cf->error( "invalid cron spec - func not specified" ) };
	return;
    };

    $me->config();

    $me;
}

################################################################
Doc::register( $doc );

1;
