# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Dec-30 23:29 (EST)
# Function: configurable objects
#
# $Id: Configable.pm,v 1.9 2004/05/05 22:47:31 jaw Exp $

package Configable;

use strict;
use vars qw($doc);

$doc = {
    package => __PACKAGE__,
    file    => __FILE__,
    isa     => [ ],
    methods => {},
    versn   => '3.2',
    fields  =>  {
	name  => {},
	type  => {},
	quotp => {},
	subtypes => {},
	confck   => {},
	conferr  => {},
	notypos  => { descr => 'no typo complaints' }, 	
    },
};

# initialize from config data according to method described in $doc
# hmmm, perhaps $doc is a poor choice of names....

my %fieldcache;
sub init_from_config {
    my $me   = shift;
    my $doc  = shift;
    my $base = shift;

    my $f = $doc->{package};
    
    # the profiler didn't like this, so we cache the field list,
    # cuts time in half and reduces the number of has_attr calls
    if( $fieldcache{$f} ){
	foreach my $k ( @{$fieldcache{$f}} ){
	    $me->init_field_from_config($doc, $base, $k);
	}
    }else{
	my @f;
	foreach my $k (keys %{$doc->{fields}}){
	    # ignore fields that are not marked configurable
	    next unless has_attr($k, $doc, 'config');
	    push @f, $k;
	    $me->init_field_from_config($doc, $base, $k);
	}
	$fieldcache{$f} = \@f;
    }
}

sub init_field_from_config {
    my $me   = shift;
    my $doc  = shift;
    my $base = shift;
    my $fld  = shift;
    my( $v, $kk );

    $kk = $fld;
    $kk =~ s/^($base)::// if $base;
    return if( $kk =~ /::/ );
    return if( $base && $fld !~ /::/ );

    # for detecting config file typos
    $me->{confck}{$kk} = 1;
    
    # does this field inherit from parent if not set?
    if( has_attr($fld, $doc, 'inherit') ){
	$v = $me->inherit( $kk );
    }elsif( has_attr($fld, $doc, 'acl') ){
	$v = $me->build_acl($kk);
    }else{
	$v = $me->{config}{$kk};
    }

    # if not set, is there a default
    $v = $doc->{fields}{$fld}{default} unless defined($v);
    
    if( has_attr($fld, $doc, 'bool') ){
	$v = ::ckbool($v) if defined($v);
    }

    # install value
    if( $base ){
	$me->{$base}{$kk} = $v if defined($v);
    }else{
	$me->{$kk} = $v if defined($v);
    }

}

# And he said unto him, I am the LORD that brought thee out of
# Ur of the Chaldees, to give thee this land to inherit it.
#     -- genesis 15:7
sub inherit {
    my $me = shift;
    my $field = shift;

    $me->{confck}{$field} = 1;
    return $me->{config}{$field} if defined $me->{config}{$field};
    # special case Host "hostname" {...}
    return $me->{name} if( $me->{type} eq 'Host' && $field eq 'hostname' );
    return $me->{parents}[0]->inherit($field) if $me->{parents}[0];
    return $Conf::Config{$field} if defined $Conf::Config{$field};
    undef;
}

# build cumulative acl
sub build_acl {
    my $me = shift;
    my $field = shift;
    my( $pv, $mv, $v, %g );

    # parent values, then mine
    if( $me->{parents}[0] ){
	$pv = $me->{parents}[0]->build_acl($field) || '';
	# yes, this could be done smarter, ...
    }else{
	$pv = $Conf::Config{$field} || '';
    }
    $mv = $me->{config}{$field} || '';
    $v = "$pv $mv";

    # process directives, etc
    foreach my $g (split /\s+/, $v){
	if( $g eq '-ALL' ){
	    %g = ();
	    next;
	}
	if( $g =~ /^-(.*)/ ){
	    delete $g{$1};
	    next;
	}
	$g{$g} = 1;
    }

    $v = join ' ', keys %g;

    $v || undef;
}

# has_attr gets called for every field for every object (or about 500 times per object)
# at a 1000 objects, this adds up to some significant time
# memoize...
my %hasattrcache = ();

sub has_attr {
    my $field = shift;
    my $doc   = shift;
    my $attr  = shift;
    my( $v );
    
    $v = $hasattrcache{ $doc->{package} }{$field}{$attr};
    return $v if defined $v;
    
    $v = grep {/$attr/} @{$doc->{fields}{$field}{attrs}};
    $hasattrcache{ $doc->{package} }{$field}{$attr} = $v;
    $v;
}

sub clearcache {
    %hasattrcache = ();
    %fieldcache = ();
}

# Error has no end.
#   -- Robert Browning, Paracelsus. Part iii.
sub check_typos {
    my $me = shift;
    my $cf = shift;

    return unless $cf;
    return if $me->{notypos};
    
    foreach my $k (keys %{$me->{config}}){
	next if $me->{confck}{$k};
	$cf->warning( "unused parameter '$k' - typo?" );
    }
}

# generate config tree for object - in config file format
sub gen_conf {
    my $me = shift;
    my( $r, $d );

    $d = Doc::objdocs($me);
    $r = $me->{type}  . ' ';
    $r .= $d->{conf}{quotp} ? "\"$me->{name}\"" : $me->{name};
    if( $d->{conf}{bodyp} || keys %{$me->{config}} ){
	$r .= " {\n";
	$r .= "\t# this object contained config errors\n"
	    if $me->{conferrs} && !$d->{conf}{notypos};
	foreach my $k (sort keys %{$me->{config}}){
	    my $v = $me->{config}{$k};
	    $v =~ s/\#/\\\#/g;
	    $v =~ s/\n/\\n\\\n/g;
	    $r .= "\t$k:\t$v";
	    $r .= "\t# unused parameter - typo?"
		unless $me->{confck}{$k} || $d->{conf}{notypos};
	    $r .= "\n";
	}
	if(exists $me->{children} || $me->{cronjobs}){
	    my $rc;
	    foreach my $c (@{$me->{cronjobs}}, @{$me->{children}}){
		$rc .= $c->gen_conf();
	    }
	    if( $rc ){
		$rc =~ s/^/\t/gm;
		$r .= "$rc";
	    }
	}
	$r .= "}";
    }
    
    $r .= "\n";
    $r;
}


1;

