# -*- perl -*-

# Copyright (c) 2003 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2003-Jan-16 22:43 (EST)
# Function: Monitor Object - for reporting Errors
#
# $Id: Error.pm,v 1.6 2004/03/04 19:08:55 jaw Exp $

# Error is the force that welds men together
#   -- Tolstoy, My Religion

package Error;
@ISA = qw(MonEl);

use strict;
use vars qw(@ISA);

sub new {
    my $class = shift || 'Error';
    my $x = {};
    bless $x, $class;
    $x;
}

sub config {
    my $me = shift;
    my $cf = shift;
    
    $me->{transient} = 1;
    $me->{status} = $me->{ovstatus} = 'down';
    return undef unless $me->init($cf);

    $me->{status} = $me->{ovstatus} =
	$me->{prevstatus} = $me->{prevovstatus} = 'down';
    
    $me->{web}{showstats} = 0;
    
    $me;
}

sub jiggle {
    my $me = shift;

    $me->transition_propagate();
}

sub webpage {
    my $me = shift;
    my $fh = shift;
    my( $k, $v, $x, $kk );

    print $fh "<!-- start of Error::webpage -->\n";
    
    # object data
    print $fh "<TABLE CLASS=ERRORDATA>\n";
    foreach $k (qw(name ovstatus error warning info note comment annotation details)){
	$v = $me->{$k};
	$kk = $k;
	$x = '';
	if( $k eq 'ovstatus' ){
	    $x = " BGCOLOR=\"" . MonEl::web_color('down') . "\"";
	    $kk = 'status';
	    $v = 'ERROR';
	}
	if( $k eq 'error' ){
	    $kk = '<B><L10N ERROR></B>';
	};
	if( $k eq 'ovstatus' || $k eq 'warning' ){
	    $v = "$v";
	}
	
	print $fh "<TR><TD>$kk</TD><TD$x>$v</TD></TR>\n" if defined($v);
    }
    
    $me->webpage_more($fh) if $me->can('webpage_more');
    print $fh "</TABLE>\n";

    $me->web_override($fh);
    
    print $fh "<!-- end of Error::webpage -->\n";
}


sub web_page_row_base {
    my $me = shift;
    my $fh = shift;
    my $label = shift;
    
    return if $me->{web}{hidden};
    my $cl = MonEl::web_color('down');
    print $fh "<TR><TD BGCOLOR=\"$cl\"><A HREF=\"", $me->url('func=page'), "\">",
        ($label||$me->{label_left}||$me->{name}), "</A></TD>";

    print $fh "<TD></TD><TD BGCOLOR=\"$cl\"><L10N ERROR></TD><TD></TD>";
    print $fh "</TR>\n";
}


1;
