# -*- perl -*-

# Copyright (c) 2005 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Created: 2005-Dec-10 12:51 (EST)
# Function: cgi graph functions
#
# $Id: web_graph.pl,v 1.2 2005/12/11 21:21:54 jaw Exp $

package Argus::Web;
use strict;
use vars qw($argusd $datadir $libdir $HAVE_GD);

sub web_graph {
    my $me = shift;
    my( $obj, $file, $which, $size, $r, $buf, $i, @opt );

    return $me->error( "Graphing support not included" ) unless $HAVE_GD;
    $obj = decode( $me->{q}->param('object') );
    $which = $me->{q}->param('which');
    $size  = $me->{q}->param('size');
    
    return unless $me->check_acl_func($obj, 'page', 1);

    $file = "$datadir/gcache/" . encode($obj) . ".$which.$size.png";
    if( -f $file ){
	my $d = (stat($file))[9];
	my $te = ($size eq 'thumb') ? 1200 : ($which eq 'samples') ? 120 : 300;
	if( $d + $te > $^T ){
	    my( $b, $i );
	    # use cached graph image
	    # print STDERR "using cached image\n";
	    open( F, $file ) || return $me->error( "could not open '$file': $!" );
	    binmode(F);
	    print $me->{q}->header( -type=>'image/png', -expires=>'+5m');
	    while( ($i=read(F, $b, 8192)) > 0 ){
		print $b;
	    }
	    close F;
	    $me->{header} = 1;
	    return;
	}
    }
    
    $r = $argusd->command( func => 'graphdata',
			   object => encode($obj),
			   );
    return $me->error( "unable to connect to server" ) unless $r;
    return $me->error( "Unable to access <I>$obj</I><BR>$r->{resultcode} $r->{resultmsg}" )
	unless $r->{resultcode} == 200;

    my $prog = decode($r->{picasso}) || "$libdir/picasso";
    @opt = ('-s', $size, '-w', $which);
    push @opt, '-l' if $r->{logscale};
    push @opt, '-g' if $r->{drawgrid};
    push @opt, '-b' if $r->{gr_binary};
    push @opt, '-T' if $r->{transparent};
    push @opt, '-B' if $r->{drawborder};
    push @opt, '-G' if $r->{gridontop};
    push @opt, '-r', decode($r->{gr_range})  if $r->{gr_range};
    push @opt, '-R', decode($r->{gr_xrange}) if $r->{gr_xrange};
    push @opt, '-x', decode($r->{xlabel})    if $r->{xlabel};
    push @opt, '-y', decode($r->{ylabel})    if $r->{ylabel};
    push @opt, '-t', decode($r->{title})     if $r->{title};
    push @opt, '-c', decode($r->{gr_colors}) if $r->{gr_colors};
    push @opt, '-C', $r->{clabels},          if $r->{clabels};
    push @opt, '-S', $r->{barstyle},	     if $r->{barstyle};
    push @opt, '-D', $r->{taglist},    	     if $r->{taglist};
    push @opt, '-L', $r->{labelstyle},       if $r->{labelstyle};
    
    $| = 1;
    print $me->{q}->header( -type=>'image/png', -expires=>'+5m');

    # print STDERR "picasso: $prog @opt $r->{list}\n";
    # ask picasso to paint the image
    open( CACHE, "> $file.$$" );
    open(PNG, '-|') ||
	exec(
	     $prog, @opt,
	     split /\s+/, $r->{list}
	     );
    binmode(CACHE);
    binmode(PNG);
    while( read(PNG, $buf, 8192) > 0 ){
	# send image to user and to cache file
	print CACHE $buf;
	print $buf;
    }
    close CACHE;
    close PNG;
    if( $? ){
	# toss tmp file if picasso had an error
	unlink "$file.$$";
    }else{
	rename "$file.$$", $file;
    }
    $me->{header} = 1;

}

sub web_graphpage {
    my $me = shift;
    my( $obj, $which, $size, $r, $back, @opt );

    return $me->error( "Graphing support not included" ) unless $HAVE_GD;
    $obj = decode( $me->{q}->param('object') );
    return unless $me->check_acl_func($obj, 'page', 1);
    
    $r = $argusd->command( func => 'graphdata',
			   object => encode($obj),
			   );
    return $me->error( "unable to connect to server" ) unless $r;
    return $me->error( "Unable to access <I>$obj</I><BR>$r->{resultcode} $r->{resultmsg}" )
	unless $r->{resultcode} == 200;

    $which = $me->{q}->param('which');
    $back  = $me->{q}->url() . "?object=" . encode($obj) . ";func=page";
    $me->startpage( "Graph $obj", undef, decode($r->{bkgimg}), decode($r->{style_sheet}), decode($r->{icon}) );
    print decode($r->{header}), "\n";

    # <A HREF="$back"><FONT COLOR="#000000">$obj</FONT></A>

    print <<XYZ;
    <TABLE WIDTH="95%" BORDER=1>
<TR BGCOLOR="#AAAAFF"><TD COLSPAN=2>
  <TABLE BORDER=0 WIDTH="100%">
    <TR> <TD ALIGN=LEFT>$obj</TD></TR>
  </TABLE>
</TD></TR>      
<TR><TD VALIGN=TOP>
XYZ
    ;
    print "<BR><CENTER>\n";
    print "<IMG WIDTH=640 HEIGHT=192 SRC=\"", $me->{q}->url(), "?object=",
    encode($obj), ";func=graph;which=$which;size=full;ext=.png\"><BR>\n";
    # print "$which\n";
    print "</CENTER><BR>\n";

    print "</TD></TR></TABLE>\n";
    print decode($r->{footer}), "\n";
    $me->endpage();
}


1;
