# -*- perl -*-

# Copyright (c) 2005 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Created: 2005-Dec-10 12:46 (EST)
# Function: cgi notify related functions
#
# $Id: web_notify.pl,v 1.3 2005/12/11 21:21:55 jaw Exp $

package Argus::Web;
use strict;
use vars qw($argusd);

sub web_ntfylist {
    my $me = shift;
    $me->notify_list( 'Notifications', 0 );
}

sub web_ntfylsua {
    my $me = shift;
    $me->notify_list( 'Unacked Notifications', 1 );
}

sub notify_list {
    my $me = shift;
    my $title = shift;
    my $ackp  = shift;
    my( $q, $r, $n );

    return unless $me->check_acl_func('Top', 'ntfylist', 1);
    # QQQ - check ACL for every object listed???
    $q = $me->{q};
    $r = $argusd->command_raw( func => 'notify_list',
			     which => $ackp ? 'unacked' : ''
			     );
    return $me->error( "unable to connect to server" ) unless $r;
    return $me->error( "Unable to access <I>notify list</I><BR>$r" ) unless $r =~ /200/;

    $me->startpage( l10n($title), 60 );
    print "<H2>$title</H2>\n";
    print $q->startform(-method=>'get'), "\n" if $ackp;
    print "<TABLE WIDTH=\"95%\" BORDER=1 CELLSPACING=0 CELLPADDING=2>\n";
    
    while( $_ = $argusd->nextline() ){
	chop;
	last if /^$/;
	$n++;
	my( $id, $stat, $creat, $obj, $msg,
	    $prio, $seve ) = split;
	my $dt   = strftime "%d/%b %R", localtime($creat);
	$dt =~ s/\s+/&nbsp\;/g;
	$obj = decode($obj);
	$msg = decode($msg);
	my $durl = "<A HREF=\"" . $q->url() . "?func=ntfydetail;idno=$id\">$id</A>";
	my $aurl = "<A HREF=\"" . $q->url() . "?func=ntfyack;idno=$id\">Ack</A>";
	my $objl = "<A HREF=\"" . $q->url() . "?object=$obj;func=page\">Object</A>";
	# QQQ - or base color on whether it is acked or not?
	my $clr  = ($stat eq 'down') ? 'FF8888' : '88FF88';
	
	if( $ackp ){
	    print "<TR BGCOLOR=\"#$clr\"><TD>$aurl</TD><TD><INPUT TYPE=checkbox NAME=idno VALUE=$id></TD>",
	    "<TD>$durl</TD><TD>$objl</TD><TD>$dt</TD><TD>$msg</TD></TR>\n";
	}else{
	    print "<TR BGCOLOR=\"#$clr\"><TD>$durl</TD><TD>$objl</TD><TD>$dt</TD><TD>$msg</TD></TR>\n";
	}
    }

    print "</TABLE>\n";
    if( $ackp && $n ){
	print "<INPUT TYPE=HIDDEN NAME=func VALUE=ntfyack>\n";
	print $q->submit(l10n("Ack Checked")), "\n";
	print $q->submit(l10n("Ack All")), "\n";
	print $q->endform(), "\n";
    }

    unless( $n ){
	if( $ackp ){
	    print l10n("There are no un-acked notifications"), "\n";
	}else{
	    print l10n("There are no notifications"), "\n";
	}
    }
    
    $me->endpage();
}

sub web_ntfyack {
    my $me = shift;
    my( $q, @id, $r );

    $q = $me->{q};

    if( $q->param('Ack All') ){
	@id = ('all');
    }else{
	@id = $q->param('idno');
    }

    foreach my $id (@id){
	return $me->error( 'Invalid Notification ID' ) unless $id =~ /^(\d+|all)$/;

	return unless $me->check_acl_ack($id, 1);
	
	$r = $argusd->command( func  => 'notify_ack',
			     user  => $me->{auth}{user},
			     idno  => $id );
	return $me->error( "unable to connect to server" ) unless $r;
	return $me->error( "Unable to access <I>$id</I><BR>$r->{resultcode} $r->{resultmsg}" )
	    unless $r->{resultcode} == 200;
    }

    if( $q->request_method() eq 'POST'){
	$me->heavy_redirect( $q->url() . "?func=ntfylsua" );
    }else{
	$me->light_redirect( $q->url() . "?func=ntfylsua" );
    }
}

sub web_ntfydetail {
    my $me = shift;
    my( $q, $id, $r, $n, $esc );

    $q = $me->{q};
    $id = $q->param('idno');
    return $me->error( 'invalid notification' ) unless $id =~ /^\d+$/;
    $r = $argusd->command( func => 'notify_detail',
			 idno => $id );

    return $me->error( "unable to connect to server" ) unless $r;
    return $me->error( "Unable to access <I>$id</I><BR>$r->{resultcode} $r->{resultmsg}" )
	unless $r->{resultcode} == 200;

    # check ACL
    unless( $me->check_acl( decode($r->{acl_ntfydetail})) ){
	return $me->web_acl_error( 'ntfydetail' );
    }
    
    $me->startpage( "Details for $id", 60 );
    print "<H2>Details for $id</H2>\n";
    
    print "<TABLE>\n";
    print "<TR><TD><B>ID</B></TD><TD>$id",
        ($r->{state} eq 'active' ? "&nbsp;&nbsp;&nbsp;<A HREF=\"". $q->url().
	 "?func=ntfyack;idno=$id\"><B>[ Ack ]</B></A>" : ''),
	"</TD></TR>\n";
    print "<TR><TD><B>Object</B></TD><TD><A HREF=\"", $q->url(), "?object=$r->{object};func=page\">",
        decode($r->{object}), "</A></TD></TR>\n";
    print "<TR><TD><B>Message</B></TD><TD>", decode($r->{msg}), "</TD></TR>\n";
    print "<TR><TD><B>Reason</B></TD><TD>", decode($r->{reason}), "</TD></TR>\n" if $r->{reason};
    print "<TR><TD><B>Created</B></TD><TD>", l10n_localtime($r->{created}), "</TD></TR>\n";
    $esc = " / <B>Escalated</B>" if $r->{escalated};
    print "<TR><TD><B>Status</B></TD><TD>$r->{state}$esc</TD></TR>\n";
    print "<TR><TD><B>Severity</B></TD><TD>$r->{severity}</TD></TR>\n" if $r->{severity};
    print "<TR><TD><B>Priority</B></TD><TD>$r->{priority}</TD></TR>\n" if $r->{priority};
    print "<TR><TD><B>Audit Detail</B></TD><TD>$r->{detail}</TD></TR>\n" if $r->{detail};

    if( $r->{ackedby} ){
	print "<TR><TD><B>Acked By</B></TD><TD>$r->{ackedby}</TD></TR>\n";
	print "<TR><TD><B>Acked At</B></TD><TD>", l10n_localtime($r->{ackedat}), "</TD></TR>\n";
    }
    print "</TABLE>\n<HR>\n";

    print "<B>Per User Status</B><BR>\n";
    print "<TABLE BORDER=1>\n<TR>\n";
    foreach my $dst (split /\s+/, $r->{statuswho}){
	my $w = decode($dst);
	my $s = $r->{"status $dst"};
	print "<TD><B>$w</B><BR>$s</TD>\n";
    }
    print "</TR>\n</TABLE>\n<HR>\n";

    print "<B>Audit Trail</B><BR>\n";
    print "<TABLE>\n";
    $n = $r->{loglines} - 1;
    foreach my $i (0..$n){
	my($t, $w, $m) = split /\s+/, $r->{"log $i"};

	$w = ($w eq '_') ? '' : decode($w);
	$m = decode($m);
	print "<TR><TD>", l10n_localtime($t), "</TD><TD>$w</TD><TD>$m</TD></TR>\n";
    }
    print "</TABLE>\n";
    $me->endpage();
    
}


1;
