# -*- perl -*-

# Copyright (c) 2007 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Created: 2007-Feb-14 12:23 (EST)
# Function: MonEl object transition
#
# $Id: Argus::MonEl::Trans.pm,v 1.4 2008/03/03 15:45:16 jaw Exp $

package MonEl;
use strict;
use vars qw(%byname %isdown %severity_sort);

# how in such short time, From eve to morn has the sun made his transit?
#      -- Dante, Divine Comedy

# something changed, determine current status
sub transition {
    my $me = shift;
    my $by = shift;
    my( $nc, $c, %cr, %co, $ca, $csv, $mst, %summary );
    my( $nr, $no );

    $mst = $me->{sirentime} || 0;
    foreach $c (@{$me->{children}}){
	my $cc = $c;
	$cc = $c->aliaslookup() if $c->can('aliaslookup');
	next if $cc->{nostatus};
	$cr{ $cc->{status} }++;
	$co{ $cc->{ovstatus} }++;
	$ca ++ if $cc->{alarm};
	$nc ++;
	
	my $cst = $cc->{sirentime} || 0;
	if( $cst > $mst && $cc->{alarm} ){
	    $mst = $cst;
	}
	$csv = $cc->{currseverity} if $cc->{ovstatus} eq 'down' &&
	    $severity_sort{$cc->{currseverity}} > $severity_sort{$csv};

	# calculate ovstatus-summary data
	foreach my $k (qw(up down override)){
	    my $v = $cc->{ovstatussummary}{$k};
	    $summary{$k} += $v;
	    $summary{total} += $v;
	    $summary{severity} = $csv;
	}
    }

    # QQQ - other states: degraded? concerned?
    if( $me->{gravity} eq "down" ){
	$nr = $cr{down} ? 'down' : 'up';
	$no = $co{down} ? 'down' : $co{override} ? 'override' : 'up';
    }else{
	if( $nc ){
	    $nr = $cr{up}   ? 'up'   : 'down';
	    # only override if everything is in override
	    $no = $co{up}   ? 'up'   : $co{down} ? 'down' : 'override';
	}else{
	    # if there no children, group is up.
	    $nr = $no = 'up';
	}
	$csv = $me->{severity};
    }

    if( $nr ne $me->{status} ){
	$me->{transtime} = $^T;
    }

    my $ps = $me->{status};
    my $po = $me->{ovstatus};
    my $pv = $me->{currseverity};
    $me->{status}   = $nr;
    $me->{ovstatus} = $no;
    
    if( $me->{ovstatus} eq 'down' ){
	$me->{currseverity} = $csv || 'critical';
    }else{
	$me->{currseverity} = 'clear';
    }
    
    if( $ca && $me->alarming_p() ){
	$me->{alarm} = 1;
	# this may get cleared later if there is an override
    }else{
	$me->{alarm} = 0;
    }

    $me->transition2();
    $me->{prevstatus}   = $ps;
    $me->{prevovstatus} = $po;
    $me->{prevseverity} = $pv;
    $me->{sirentime} = $mst if $me->{alarm};

    # finish calculating ovstatus-summary
    if( $me->{countstop} ){
	%summary = ( $me->{ovstatus} => 1, total => 1, severity => $me->{currseverity} );
    }
    if( $me->{override} ){
	my $t = $summary{total};
	%summary = ( override => $t, total => $t, severity => $me->{currseverity} );
    }
    $me->{ovstatussummary} = \%summary;
    
    $me->loggit( msg => ($by->{label_left} || $by->{label} || $by->{name}),
		 tag => 'TRANSITION',
		 lss => 1,
		 slp => 1 ) if ($me->{prevovstatus} ne $me->{ovstatus})
		            || ($me->{prevseverity} ne $me->{currseverity});

    $me->transition_propagate();
}

sub transition2 {
    my $me = shift;

    if( $me->{override} ){
	# set override
	$me->{ovstatus} = 'override' unless $me->{status} eq 'up';

	# clear alarm, since we are in override
	$me->{alarm}    = 0;
	# clear severity
	$me->{currseverity} = 'clear';
	# clear override
	if( $me->{status} eq 'up' && $me->{override}{mode} eq 'auto' ){
	    $me->override_remove();
	    # $me->{prevovstatus} = 'override';
	}
    }

    delete $me->{depend}{culprit};
    $me->check_depends() if $me->{depends} && ($me->{status} eq 'down');
    
    # update stats
    $me->stats_transition();
    
    # webpage
    $me->{web}{transtime} = $^T;

    # Canst thou draw out leviathan with an hook?
    #   -- Job 41:1
    if( $me->can('transition_hook') ){
	# so user can diddle things
	$me->transition_hook();
    }
    
}

# That labour on the bosom of this sphere, To propagate their states
#     -- Shakespeare, Timon of Athens

# propagate transition change to parents
sub transition_propagate {
    my $me = shift;


    # send page
    # NB - previously, this checked status, causing, if in override, a notify to
    # be created but immediately acked and not sent
    # RSN - also for change in severity
    if(    $me->{prevovstatus} && ($me->{ovstatus} ne $me->{prevovstatus})
	|| $me->{prevseverity} && ($me->{currseverity} ne $me->{prevseverity}) ){

	# audit trail notify channel
	if( $me->{notify}{notifyaudit} ){
	    Notify::new( $me,
			 audit  => 1,
			 detail => "$me->{prevovstatus}/$me->{prevseverity} -> $me->{ovstatus}/$me->{currseverity}",
			 );
	}

	if( $me->can('transition_audit_hook') ){
	    $me->transition_audit_hook();
	}
	
	# do not notify if an ancestor, or me is in override
	if( !$me->{anc_in_ov} && !$me->{override}
	# and not down/depends
	&& $me->{ovstatus} ne 'depends'
	){
	    # but not if I just came out of override to up
	    unless( $me->{prevovstatus} eq 'override' && $me->{ovstatus} eq 'up'
		    || $me->{prevovstatus} eq 'depends'  && $me->{ovstatus} eq 'up'
		    ){
		# QQQ - why is the above code so ugly and complex?
		# QQQ - should it all be kicked to N:new? (making that ugly and complex)
	      Notify::new( $me );
	    }
	}
    }
    
    # update hushed sirens if me transitions
    if( $me->{prevovstatus} && ($me->{ovstatus} ne $me->{prevovstatus})
	&& ($me->{ovstatus} eq 'down') && $me->{alarm} ){
	$me->{sirentime} = $^T; 
    }

    if( $me->{ovstatus} eq 'down' ){
	$isdown{ $me->unique() } = 1;
    }else{
	delete $isdown{ $me->unique() };
    }
    
    foreach my $p ( @{$me->{parents}} ){
	$p->transition( $me );
    }

    # and notify anything depending on me
    if( $me->{ovstatus} eq 'up' ){
	foreach my $d (split /\s+/, $me->{depend}{onme}){
	    my $dx = $byname{$d};
	    next unless $dx;
	    next unless $dx->{ovstatus} eq 'depends';
	    $dx->transition( $dx->{status} );
	}
	delete $me->{depend}{onme};
    }
    
}

sub alarming_p {
    my $me = shift;

    return 0 if $me->{status} ne 'down';
    my $s = $me->{"siren.$me->{currseverity}"};
    return $s if defined $s;
    return $me->{siren};
}

1;
