# -*- perl -*-

# Copyright (c) 2007 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Created: 2007-Dec-30 15:42 (EST)
# Function: web page overview
#
# $Id: Argus::Web::Overview.pm,v 1.2 2008/02/03 03:00:42 jaw Exp $

package MonEl;
use strict;
use vars qw(%byname %isdown %inoverride);


sub web_overview {

    my $file = "$::datadir/html/" . ::hashed_directory('overview') . '/overview';
    my $top  = $::Top;
    
    return $file if( ($top->{web}{buildtimeov} > $top->{web}{transtime})
		  && ($top->{web}{buildtimeov} > Notify::lastupd()) );
    
    my $fh = BaseIO::anon_fh();
    return ::loggit( "Cannot open web file '$file': $!", 0 )
	unless open( $fh, "> $file" ) ;
    $top->{web}{buildtimeov} = $^T;

    $top->web_header($fh, 'Overview', 'Overview' );
    
    print $fh "<TABLE WIDTH=\"95%\" BORDER=1 CLASS=OVERVIEW>\n";
    
    $top->web_show_has_errors($fh, 3) if $Conf::has_errors;

    my $color = $Conf::has_errors ? 'FF8888' : 'AAAAFF';
    
    print $fh <<X;
<TR BGCOLOR="#$color"><TD COLSPAN=3>
  <TABLE BORDER=0 WIDTH="100%" CLASS=TOPBAR>
    <TR><TD ALIGN=LEFT><L10N Overview></TD> <TD ALIGN=RIGHT><L10N User>: <TT>__USER__</TT></TD>
    </TR>
  </TABLE>
</TD></TR>
<TR>
X
    ;

    # interesting down, override, unacked
    # recent notify?
    web_overview_down($fh);
    web_overview_override($fh);
    web_overview_unacked($fh);
    
    
    print $fh "</TR>\n</TABLE>\n";

    $top->web_footer($fh);
    
    return $file;
}

sub web_overview_down {
    my $fh = shift;

    print $fh <<XD;
<TD VALIGN=TOP>
<center><b><L10N Down></b></center>
<table class=overviewdown>
XD
    ;

    my @obj = map { $byname{$_} } keys %isdown;
    # newest first
    for my $x (sort { $b->{transtime} <=> $a->{transtime} } @obj){
	next unless $x;
	next unless $x->{interesting};
	next if $x->{anc_in_ov};
	next if $x->{ovstatus} eq 'depends';
	my $url   = $x->url('func=page');
	my $label = $x->{label_overview} || $x->unique();
	my $color = MonEl::web_color($x->{ovstatus}, $x->{currseverity});

	print $fh "<!-- START AUTHORIZATION RW NEEDED $x->{acl_page} -->\n";
	print $fh "<tr><td BGCOLOR=\"$color\"><a href=\"$url\"><font color=\"#000000\">$label</font></a></td></tr>\n";
	print $fh "<!-- END AUTHORIZATION RW NEEDED -->\n";
    }
    
    print $fh "</table>\n</TD>\n";
}

sub web_overview_override {
    my $fh = shift;

    print $fh <<XD;
<TD VALIGN=TOP>
<center><b><L10N Override></b></center>
<table class=overviewoverride>
XD
    ;

    my @obj = values %inoverride;
    # newest first
    for my $x (sort { $b->{override}{time} <=> $a->{override}{time} } @obj){
	next unless $x;
	my $url   = $x->url('func=page');
	my $label = $x->{label_overview} || $x->unique();
	my $color = MonEl::web_color($x->{ovstatus}, $x->{currseverity});

	print $fh "<!-- START AUTHORIZATION RW NEEDED $x->{acl_page} -->\n";
	print $fh "<tr><td BGCOLOR=\"$color\"><a href=\"$url\"><font color=\"#000000\">$label</font></a></td></tr>\n";
	print $fh "<!-- END AUTHORIZATION RW NEEDED -->\n";
    }

    print $fh "</table>\n</TD>\n";
}

sub web_overview_unacked {
    my $fh = shift;

    print $fh <<XD;
<TD VALIGN=TOP>
<center><b><L10N Un-Acked Notifies></b></center>
<table class=overviewunacked>
XD
    ;

    my $unacked = Notify::unacked();
    for my $p (sort {$a->{created} <=> $b->{created}} values %$unacked){
	my $color = ($p->{status} eq 'acked') ? '88FF88' : 'FF8888';
	my $txt = $p->{msg};
	$txt =~ s/\n/<br>\n/gs;
	my $url = "__BASEURL__?func=ntfydetail;idno=$p->{idno}";

	print $fh "<!-- START AUTHORIZATION RW NEEDED $p->{obj}{acl_page} -->\n";
	print $fh "<tr><td BGCOLOR=\"$color\"><a href=\"$url\"><font color=\"#000000\">$txt</font></a></td></tr>\n";
	print $fh "<!-- END AUTHORIZATION RW NEEDED -->\n";
    }

    print $fh "</table>\n</TD>\n";    
}


1;
