# -*- perl -*-

# Copyright (c) 2003 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Created: 2003-Dec-15 10:47 (EST)
# Function: misc DARP stuff
#
# $Id: DARP::Misc.pm,v 1.12 2007/12/22 21:47:10 jaw Exp $

package DARP::Misc;

use strict qw(refs vars);
use vars qw($doc);

$doc = {
    package => __PACKAGE__,
    file    => __FILE__,
    isa     => [],
    versn => '3.3',
    html  => 'darp',
    methods => {},

    fields => {
	
	slaves_keep_state => {
	    descr => 'which servers keep status files',
	    attrs => ['config', 'inherit'],
	    default => '*',
	},
	slaves_send_notifies => {
	    descr => 'which servers should send notifications',	
	    attrs => ['config', 'inherit'],
	    default => '*',
	},

	master_notif_gravity => {
	    descr => 'multi-master gravitation method',
	    attrs => ['config', 'inherit'],
	},
	
      darp::i_keep_state => {},
      darp::i_send_notif => {},
      darp::send_notif_tags => {},

    },
};

# save and replace various functions
my $stats_load = \&MonEl::stats_load;
my $stats_save = \&MonEl::stats_save;
my $notify_new = \&Notify::new;

sub enable {
    no strict;
    *{'MonEl::stats_load'} = \&stats_load;
    *{'MonEl::stats_save'} = \&stats_save;
    *{'Notify::new'}       = \&notify;
}

# QQQ stats_hourly, stats_transition

################################################################


# called from MonEl::init
sub init {
    my $me = shift;
    my $cf = shift;
    my( $self, @tags );

    $me->init_from_config( $cf, $doc, '' );
    
    if( $DARP::info && $DARP::info->{tag} ){
	$self = $DARP::info->{tag};
	
	@tags = DARP::taglist( $me->{slaves_keep_state} );
	$me->{darp}{i_keep_state} = 1 if grep { $self eq $_ } @tags;
	
	@tags = DARP::taglist( $me->{slaves_send_notifies} );
	$me->{darp}{i_send_notif} = 1 if grep { $self eq $_ } @tags;
	$me->{darp}{send_notif_tags}{$_} = 1 foreach @tags;
	
    }else{
	# DARP not enabled
	$me->{darp}{i_keep_state} = 1;
	$me->{darp}{i_send_notif} = 1;
    }
    
}

sub stats_load {
    my $me = shift;

    return unless $me->{darp}{i_keep_state};
    $stats_load->( $me, @_ );
}

sub stats_save {
    my $me = shift;

    return unless $me->{darp}{i_keep_state};
    $stats_save->( $me, @_ );
}


sub notify {
    my $me = shift;

    return unless $me->{darp}{i_send_notif};

    my $ngrav = $me->{master_notif_gravity};
    
    if( $ngrav eq 'low' || $ngrav eq 'high' ){
	my $self = $DARP::info->{tag};

	# be semi-pessimistic, rather send 2 than none
	my %candidate;
	if( $DARP::info && $DARP::info->{all} ){
	    foreach my $d ( @{ $DARP::info->{all} } ){
		my $t = $d->{name};
		next unless $me->{darp}{send_notif_tags}{$t};
		
		push @{$candidate{$t}}, $d;
	    }
	}

	T: foreach my $t (keys %candidate){
	    # all connections to T must be up in S+M mode
	    foreach my $d ( @{$candidate{$t}} ){
		next T if $d->{status} ne 'up';
		next T if $d->{srvc} && $d->{srvc}{status} ne 'up';
	    }
	    
	    # T looks good, is it better than me?
	    if( $ngrav eq 'low' ){
		return if $t lt $self;
	    }else{
		return if $t gt $self;
	    }
	}
    }

    $notify_new->( $me, @_ );
}

################################################################
Doc::register( $doc );

1;
