# -*- perl -*-

# Copyright (c) 2012
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Created: 2012-Sep-15 12:45 (EDT)
# Function: custom dashboards
#
# $Id: Argus::Dashboard.pm,v 1.2 2012/09/16 18:52:49 jaw Exp $

package Argus::Dashboard;
@ISA = qw(Configable);
use vars qw(@ISA $doc);

use Argus::Color;
use Argus::Encode;
use Argus::Dashboard::Row;
use Argus::Dashboard::Col;
use Argus::Dashboard::Widget;
use strict;

my %alldash = ();


my @param = qw(cssid cssclass style);
$doc = {
    package => __PACKAGE__,
    file    => __FILE__,
    isa     => [],
    versn => '3.7',
    html  => 'dashboard',
    methods => {},
    conf => {
	quotp => 1,
	bodyp => 1,
    },
    fields => {
        map {
            ($_ => {
                descr => 'dashboard layout parameter',
                attrs => ['config'],
            })
        } @param,
    },
};

sub find {
    my $name = shift;

    $name =~ s/^Dash://i;
    return $alldash{ $name };
}

sub list {
    return keys %alldash;
}

sub config {
    my $me = shift;
    my $cf = shift;
    my $more = shift;

    $me->init_from_config( $cf, $doc, '' );
    $me->{maxwidth} = $me->width();
    $me->check($cf);

    $alldash{ $me->{name} } = $me;
}

sub check {
    my $me = shift;
    my $cf = shift;

    $me->check_typos( $cf ) if $cf;
    Doc::check( $me )       if $::opt_T;

}

sub width {
    my $me = shift;

    my $max;
    for my $c (@{$me->{children}}){
        my $w = $c->width();
        $max = $w if $w > $max;
    }
    return $max;
}

sub pathname {
    my $me = shift;

    my $f = encode('Dash:' . $me->{name});
    my $d = ::hashed_directory($f);

    return "$d/$f";

}

sub web_build {
    my $me = shift;

    my $top  = $::Top;
    my $file = "$::datadir/html/" . $me->pathname();

    my $fh = BaseIO::anon_fh();
    return ::loggit( "Cannot open web file '$file': $!", 0 )
	unless open( $fh, "> $file" ) ;
    $top->{web}{buildtime} = $^T;

    $top->web_header($fh, "Dashboard : $me->{name}", 'dashboard' );
    print $fh "<TABLE WIDTH=\"100%\" BORDER=0 CLASS=DASHBOARD>\n";
    $top->web_branding($fh, 2);
    $top->web_show_has_errors($fh, 2) if $Conf::has_errors;

    my $color = web_element_color( $Conf::has_errors ? 'top_error' : 'top_normal' );
    my $attr  = $me->attr();

    print $fh <<X;
<!-- PUT WARNINGS HERE -->
<TR BGCOLOR="$color"><TD COLSPAN=2>
  <TABLE BORDER=0 WIDTH="100%" CLASS=TOPBAR>
    <TR><TD ALIGN=LEFT class=objectname><L10N Dashboard> : $me->{name}</TD> <TD ALIGN=RIGHT class=username><L10N User>: <TT>__USER__</TT></TD>
    </TR>
  </TABLE>
</TD></TR>
<TR><TD colspan=2><TABLE $attr cellpadding=2 cellspacing=0 border=0>
X
    ;

    for my $c ( @{$me->{children}} ){
        $c->web_make($fh);
    }


    print $fh "</TABLE></TD></TR></TABLE>\n";
    $top->web_footer($fh);
    return $file;
}

sub attr {
    my $me = shift;

    my $t;
    $t .= " class=\"$me->{cssclass}\"" if $me->{cssclass};
    $t .= " class=\"$me->{cssid}\"" if $me->{cssid};

    for my $a (@_){
        $t .= " $a=\"$me->{$a}\"" if $me->{$a};
    }

    return $t;
}


sub gen_confs {
    my( $r );

    foreach my $d (sort {$a->{name} cmp $b->{name}} values %alldash){
        $r .= $d->gen_conf();
    }
    $r = "\n$r" if $r;

    $r;
}


################################################################
Doc::register( $doc );

1;
