# -*- perl -*-

# Copyright (c) 2002 by Jeff Weisberg
# Author: Jeff Weisberg <argus @ tcp4me.com>
# Date: 2002-Oct-31 13:37 (EST)
# Function: client side of graph data collector
#
# $Id: Graph.pm,v 1.12 2011/10/26 15:42:22 jaw Exp $

# send data samples to a graphing daemon

package Graph;
use Argus::Archivist;
@ISA = qw(Argus::Archivist);

use Socket;
use POSIX ('_exit');
use strict qw(refs vars);
use vars qw($doc @ISA);

my $graph;

sub new {

    $graph = __PACKAGE__->SUPER::new(
			       prog => (::topconf('graphd_prog') || "$::libdir/graphd"),
			       );
}

sub write {
    my $msg = shift;

    unless( $graph ){
	new() || return;
    }

    $graph->SUPER::write( $msg );
}


# Done to death by slanderous tongues
#   -- Shakespeare, Much Ado about Nothing
sub done {
    my $me = shift;
    
    $me->SUPER::done();
    $graph = undef if $graph == $me;
}


################################################################

sub Service::graph_add_sample {
    my $me  = shift;
    my $val = shift;
    my $st  = shift;

    $val = $me->{srvc}{elapsed}
    	if $me->{image}{gr_what} eq 'elapsed';
    $val = $st eq 'up' ? 1 : 0
	if $me->{image}{gr_what} eq 'status';
    
    $val = 0 unless defined $val;
    
    # make numeric
    if( $val + 0 ){
	$val += 0;
    }else{
	$val =~ s/^.*(-?\d+\.?\d*).*/$1/s;
	$val += 0 ;
    }

    # NB: normal graphd does not use tag in any way
    # provided for interesting add-ons
    my $tag;
    $tag = $me->graph_tag() if $me->can('graph_tag');
    $tag ||= '';

    my( $expect, $delta ) = (0,0);
    if( $me->{hwab} && $me->{hwab}{expect} ){
        $expect = $me->{hwab}{expect}{y};
        $delta  = $me->{hwab}{expect}{d};
    }

    # sizes?
    my $ss = $me->{graphd}{gr_nmax_samples} || 0;
    my $hs = $me->{graphd}{gr_nmax_hours}   || 0;
    my $ds = $me->{graphd}{gr_nmax_days}    || 0;

    Graph::write( "sample $^T " . $me->pathname() . " $st $val $ss $hs $ds $expect $delta $tag\n" );
}

1;

